#!/bin/sh -e

# xz Build
cd /maple
treetap build sources/xz/xz.spec
cd .treetap/sources/xz/*/*/xz-*/
make -j $(nproc) install DESTDIR=/

# libarchive Build
cd /maple
treetap build sources/libarchive/libarchive.spec
cd .treetap/sources/libarchive/*/*/libarchive-*/
make -j $(nproc) install DESTDIR=/

# Now we can build stuff exclusively with treetap
PACKAGES="libarchive xz"
for pkg in $PACKAGES; do
    treetap fetch sources/$pkg/$pkg.spec
    treetap build sources/$pkg/$pkg.spec
    treetap package sources/$pkg/$pkg.spec
    treetap install .treetap/packages/*/$pkg-*.cpio.xz
done